<?php

$grupo_version = 0;
$redirect = null;
$missing_extensions = '';
$system_message = '';

if (!file_exists('upgrade_info.php')) {
    if (file_exists('pre_sql_queries.done')) {
        unlink('pre_sql_queries.done');
    }

    if (file_exists('../include/config.php')) {
        copy('../include/config.php', 'old_site_config.php');
    }

    if (file_exists('../door') && file_exists('../key') && file_exists('../knob')) {
        $grupo_version = 2;
    } elseif (file_exists('../fns') && file_exists('../include') && file_exists('../pages')) {
        $grupo_version = 3;
    }

    if ($grupo_version == 0) {
        $system_message = 'Oops! We couldn\'t determine your current Grupo Version. <br>';
        $system_message .= 'Please make sure you\'ve uploaded the "upgrade" folder to the correct location.';
    } else {
        if (!extension_loaded('zip')) {
            $missing_extensions .= 'PHP Zip extension, ';
        }

        if (!extension_loaded('gd')) {
            $missing_extensions .= 'PHP GD extension, ';
        }

        if (!extension_loaded('pdo_mysql')) {
            $missing_extensions .= 'PHP PDO MySQL extension';
        }

        if (is_dir('../fns')) {
            if (!is_writable('../assets/files/')) {
                chmod('../assets/files/', 0755);
            }

            if (!is_writable('../fns')) {
                chmod('../fns', 0755);
            }
        }

        if (version_compare(PHP_VERSION, '8.0', '>=') && empty($missing_extensions)) {
            if ((is_writable('../assets/files/') && is_writable('../fns') && is_writable('upgrade_image')) || (is_writable('../door') && is_writable('upgrade_image'))) {
                $upgrade_info = ['grupo_version' => $grupo_version];
                $file_content = json_encode($upgrade_info);

                if (file_exists("upgrade_info.php")) {
                    unlink("upgrade_info.php");
                }

                file_put_contents("upgrade_info.php", $file_content);

                $redirect = 'verify_database';
            } else {
                $system_message = 'Please verify the permissions for all folders, including [assets/files] folder, and ensure everything is configured correctly.';
            }
        } else {

            if (version_compare(PHP_VERSION, '8.0', '<')) {
                $system_message = 'You are using an outdated PHP version. Please upgrade to 8.1 or higher. ';
            }
            if (!empty($missing_extensions)) {
                $system_message .= 'The following PHP extension(s) are missing or disabled on your server: ' . rtrim($missing_extensions, ", ");
            }
        }
    }
} else {
    $redirect = 'verify_database';
}

if (!empty($redirect)) {
    $page_content = [
        'title' => 'Verifying Database',
        'loading_text' => 'Verifying Database',
        'subtitle' => 'Please Wait',
        'redirect' => 'index.php?process=verify_database'
    ];
} else {
    $page_content = [
        'title' => 'Error',
        'page_content' => $system_message,
        'heading' => 'Oops',
        'page_status' => 'error',
        'button_text' => 'Reload',
        'button_link' => 'index.php?process=initial'
    ];
}
