<?php

if (!file_exists('pre_sql_queries.done')) {
    $pre_sql_queries = array();
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP FOREIGN KEY `user_id_fk_8`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP INDEX `user_id_fk_8`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP FOREIGN KEY `private_message_id_fk`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP INDEX `private_message_id_fk`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP FOREIGN KEY `group_message_id_fk_2`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP INDEX `group_message_id_fk_2`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP FOREIGN KEY `group_id_fk_5`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_complaints` DROP INDEX `group_id_fk_5`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_mailbox` DROP FOREIGN KEY `user_id_fk_11`;';
    $pre_sql_queries[] = 'ALTER TABLE `gr_mailbox` DROP INDEX `user_id_fk_11`;';

    foreach ($pre_sql_queries as $pre_sql_query) {
        try {
            $pre_sql_exec = DB::connect()->query($pre_sql_query);
            if ($pre_sql_exec) {
                $pre_sql_exec->closeCursor();
            }
        } catch (Exception $e) {
        }
    }
    @file_put_contents('pre_sql_queries.done', 'done');
}


$db_tables_query = DB::connect()->query("SHOW TABLES LIKE 'new_grupo_version_%'");
$db_tables = $db_tables_query->fetchAll();
if ($db_tables_query) {
    $db_tables_query->closeCursor();
}

$add_index_sql = '';
$repeat_task = false;
$log_query = true;

if (count($db_tables) > 5) {
    $db_tables = array_slice($db_tables, 0, 5);
}

if (count($db_tables) > 2) {
    $repeat_task = true;
}
if (count($db_tables) > 0) {
    foreach ($db_tables as $db_table) {
        $db_table_name = $db_table[0];
        $check_table = str_replace('new_grupo_version_', 'gr_', $db_table_name);
        $check_db_query = DB::connect()->query("SHOW TABLES LIKE '" . $check_table . "'");
        $check_db = $check_db_query->fetchAll();
        if ($check_db_query) {
            $check_db_query->closeCursor();
        }

        if (count($check_db) === 0) {
            $rename_table = 'ALTER TABLE ' . $db_table_name . ' RENAME TO ' . $check_table . ';';

            $query = 'SELECT clms.`COLUMN_NAME`,clms.`CHARACTER_MAXIMUM_LENGTH`,clms.`COLUMN_TYPE`,clms.`COLUMN_COMMENT`,';
            $query .= 'clms.`COLUMN_KEY`,clms.`COLUMN_DEFAULT`,clms.`IS_NULLABLE`,clms.`DATA_TYPE`';
            $query .= ',rc.`CONSTRAINT_NAME`,rc.`UPDATE_RULE`, kcu.`REFERENCED_COLUMN_NAME`, ';
            $query .= 'rc.`DELETE_RULE`,rc.`REFERENCED_TABLE_NAME` ';
            $query .= 'FROM INFORMATION_SCHEMA.COLUMNS clms ';
            $query .= 'LEFT JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu ';
            $query .= 'USING (COLUMN_NAME, TABLE_NAME, TABLE_SCHEMA) ';
            $query .= 'LEFT JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc ';
            $query .= 'USING (CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME) ';
            $query .= 'WHERE clms.TABLE_SCHEMA = DATABASE() ';
            $query .= "AND clms.TABLE_NAME = '" . $db_table_name . "'";

            $table_constraints_query = DB::connect()->query($query);
            $table_constraints = $table_constraints_query->fetchAll();
            if ($table_constraints_query) {
                $table_constraints_query->closeCursor();
            }
            foreach ($table_constraints as $table_constraint) {
                if (!empty($table_constraint['CONSTRAINT_NAME']) && !empty($table_constraint['REFERENCED_COLUMN_NAME'])) {
                    $new_constraint_name = str_replace('new_version_', '', $table_constraint['CONSTRAINT_NAME']);
                    $new_db_table_name = str_replace('new_grupo_version_', 'gr_', $db_table_name);

                    $reference_table_name = $table_constraint['REFERENCED_TABLE_NAME'];
                    $reference_table_name = str_replace('new_grupo_version_', 'gr_', $reference_table_name);

                    $find_table = "SHOW TABLES LIKE '" . $reference_table_name . "'";
                    $find_table_query = DB::connect()->query($find_table);
                    $find_table = $find_table_query->fetchAll();
                    if ($find_table_query) {
                        $find_table_query->closeCursor();
                    }
                    if (count($find_table) === 0) {
                        $reference_table_name = $table_constraint['REFERENCED_TABLE_NAME'];
                    }

                    $rename_table .= 'ALTER TABLE `' . $new_db_table_name . '` DROP FOREIGN KEY `' . $table_constraint['CONSTRAINT_NAME'] . '`;';

                    $foregin_key_column = $table_constraint['COLUMN_NAME'];

                    $rename_table .= 'ALTER TABLE `' . $new_db_table_name . '` ADD CONSTRAINT `' . $new_constraint_name . '` ';
                    $rename_table .= 'FOREIGN KEY (`' . $foregin_key_column . '`) REFERENCES `' . $reference_table_name . '`(`' . $table_constraint['REFERENCED_COLUMN_NAME'] . '`) ';

                    if (isset($table_constraint['DELETE_RULE']) && !empty($table_constraint['DELETE_RULE'])) {
                        $rename_table .= 'ON DELETE ' . $table_constraint['DELETE_RULE'];
                    } else {
                        $rename_table .= 'ON DELETE RESTRICT';
                    }

                    if (isset($table_constraint['UPDATE_RULE']) && !empty($table_constraint['UPDATE_RULE'])) {
                        $rename_table .= ' ON UPDATE ' . $table_constraint['UPDATE_RULE'];
                    } else {
                        $rename_table .= ' ON UPDATE RESTRICT';
                    }
                    $rename_table .= ';';
                }
            }

            if ($log_query) {
                add_to_error_log($rename_table);
            }

            $rename_table_query = DB::connect()->query($rename_table);
            if ($rename_table_query) {
                $rename_table_query->closeCursor();
            }
        } else {
            $query = 'SELECT clms.`COLUMN_NAME`,clms.`CHARACTER_MAXIMUM_LENGTH`,clms.`COLUMN_TYPE`,clms.`COLUMN_COMMENT`,';
            $query .= 'clms.`COLUMN_KEY`,clms.`COLUMN_DEFAULT`,clms.`IS_NULLABLE`,clms.`DATA_TYPE`';
            $query .= ',rc.`CONSTRAINT_NAME`,rc.`UPDATE_RULE`, kcu.`REFERENCED_COLUMN_NAME`, ';
            $query .= 'rc.`DELETE_RULE`,rc.`REFERENCED_TABLE_NAME` ';
            $query .= 'FROM INFORMATION_SCHEMA.COLUMNS clms ';
            $query .= 'LEFT JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu ';
            $query .= 'USING (COLUMN_NAME, TABLE_NAME, TABLE_SCHEMA) ';
            $query .= 'LEFT JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc ';
            $query .= 'USING (CONSTRAINT_CATALOG, CONSTRAINT_SCHEMA, CONSTRAINT_NAME) ';
            $query .= 'WHERE clms.TABLE_SCHEMA = DATABASE() ';
            $query .= "AND clms.TABLE_NAME = '" . $db_table_name . "'";

            $new_db_table_query = DB::connect()->query($query);
            $new_db_table = $new_db_table_query->fetchAll();

            if ($new_db_table_query) {
                $new_db_table_query->closeCursor();
            }
            $query = 'SELECT `COLUMN_NAME` FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE `TABLE_NAME`=' . "'" . $check_table . "'";
            $query .= " AND `TABLE_SCHEMA`='" . $GLOBALS["database_info"]["database"] . "'";

            $old_db_table_query = DB::connect()->query($query);
            $old_db_table = $old_db_table_query->fetchAll();

            if ($old_db_table_query) {
                $old_db_table_query->closeCursor();
            }

            $old_db_table_columns = array();

            foreach ($old_db_table as $column) {
                $column = $column['COLUMN_NAME'];
                $old_db_table_columns[$column] = true;
            }

            foreach ($new_db_table as $column) {
                $check_column = $column['COLUMN_NAME'];
                $sql_query = '';
                if (!isset($old_db_table_columns[$check_column])) {
                    $data_type = strtoupper($column['COLUMN_TYPE']);
                    $null_value = ' NOT NULL';
                    $default_value = '';

                    if (strtolower($column['IS_NULLABLE']) !== 'no') {
                        $null_value = ' NULL';
                    }

                    $skip_default_value = false;
                    if (strpos(strtoupper($data_type), 'INT') !== false || strpos(strtoupper($data_type), 'DECIMAL') !== false) {
                        if ($column['COLUMN_DEFAULT'] === 'NULL') {
                            $skip_default_value = true;
                        }
                    }

                    if (!$skip_default_value) {
                        if (!empty($column['COLUMN_DEFAULT']) || is_numeric($column['COLUMN_DEFAULT'])) {
                            if ($column['COLUMN_DEFAULT'] === 'NULL') {
                                $default_value = " DEFAULT NULL";
                            } else {
                                $column_default = str_replace("'", "", $column['COLUMN_DEFAULT']);
                                $column_default = str_replace('"', '', $column_default);
                                $default_value = " DEFAULT '" . $column_default . "'";
                            }
                        }
                    }

                    $sql_query = 'ALTER TABLE `' . $check_table . '` ADD `' . $check_column . '` ' . $data_type . $null_value . $default_value . ';';

                    if (!empty($column['CONSTRAINT_NAME']) && !empty($column['REFERENCED_COLUMN_NAME'])) {
                        $sql_query .= 'ALTER TABLE `' . $db_table_name . '` DROP FOREIGN KEY `' . $column['CONSTRAINT_NAME'] . '`;';

                        $reference_tb = str_replace('new_grupo_version_', 'gr_', $column['REFERENCED_TABLE_NAME']);
                        $new_constraint_name = str_replace('new_version_', '', $column['CONSTRAINT_NAME']);

                        $find_table = "SHOW TABLES LIKE '" . $reference_tb . "'";
                        $find_table_query = DB::connect()->query($find_table);
                        $find_table = $find_table_query->fetchAll();

                        if ($find_table_query) {
                            $find_table_query->closeCursor();
                        }

                        if (count($find_table) === 0) {
                            $reference_tb = $column['REFERENCED_TABLE_NAME'];
                        }

                        $sql_query .= 'ALTER TABLE `' . $check_table . '` ADD CONSTRAINT `' . $new_constraint_name . '` ';
                        $sql_query .= 'FOREIGN KEY (`' . $check_column . '`) ';
                        $sql_query .= 'REFERENCES `' . $reference_tb . '`(`' . $column['REFERENCED_COLUMN_NAME'] . '`) ';

                        if (isset($column['DELETE_RULE']) && !empty($column['DELETE_RULE'])) {
                            $sql_query .= 'ON DELETE ' . $column['DELETE_RULE'];
                        } else {
                            $sql_query .= 'ON DELETE RESTRICT';
                        }

                        if (isset($column['UPDATE_RULE']) && !empty($column['UPDATE_RULE'])) {
                            $sql_query .= ' ON UPDATE ' . $column['UPDATE_RULE'];
                        } else {
                            $sql_query .= ' ON UPDATE RESTRICT';
                        }
                        $sql_query .= ';';
                    }

                    if (!empty($sql_query)) {
                        try {
                            $sql_query_exec = DB::connect()->query($sql_query);

                            if ($sql_query_exec) {
                                $sql_query_exec->closeCursor();
                            }

                            if ($log_query) {
                                add_to_error_log($sql_query);
                            }
                        } catch (PDOException $e) {
                            $error_message = $e->getMessage();
                            add_to_error_log($error_message);
                        }
                    }
                }
            }

            $new_tb_indexes = 'SHOW INDEX FROM ' . $db_table_name . ' FROM ' . $GLOBALS["database_info"]["database"] . ';';
            $new_tb_indexes_query = DB::connect()->query($new_tb_indexes);
            $new_tb_indexes = $new_tb_indexes_query->fetchAll();

            if ($new_tb_indexes_query) {
                $new_tb_indexes_query->closeCursor();
            }

            $old_tb_indexes = 'SHOW INDEX FROM ' . $check_table . ' FROM ' . $GLOBALS["database_info"]["database"] . ';';
            $old_tb_indexes_query = DB::connect()->query($old_tb_indexes);
            $old_tb_indexes = $old_tb_indexes_query->fetchAll();

            if ($old_tb_indexes_query) {
                $old_tb_indexes_query->closeCursor();
            }

            $old_db_indexes = array();

            foreach ($old_tb_indexes as $db_index) {
                $old_db_indexes[] = $db_index['Key_name'];
            }
            $add_indexes = array();

            foreach ($new_tb_indexes as $db_index) {
                $key_name = $db_index['Key_name'];
                $column_name = $db_index['Column_name'];
                $key_name = str_replace('new_grupo_version_', '', $key_name);
                if (!in_array($key_name, $old_db_indexes)) {
                    if (!empty($key_name) && !empty($column_name)) {
                        $add_indexes[$key_name][] = $db_index['Column_name'];
                    }
                }
            }

            foreach ($add_indexes as $inx_key => $inx_columns) {
                $inx_columns = "`" . implode("`, `", $inx_columns) . "`";
                $add_index_sql .= 'Alter table ' . $check_table . ' add index `' . $inx_key . '`(' . $inx_columns . ');';
            }
        }
        $skip_tables = ['new_grupo_version_language_strings', 'new_grupo_version_settings'];
        if (!in_array($db_table_name, $skip_tables)) {
            $query = "DROP TABLE " . $db_table_name;
            try {
                $sql_query_exec = DB::connect()->query($query);

                if ($sql_query_exec) {
                    $sql_query_exec->closeCursor();
                }

                if ($log_query) {
                    add_to_error_log($sql_query);
                }
            } catch (PDOException $e) {
                $error_message = $e->getMessage();
                add_to_error_log($error_message);
                $repeat_task = true;
            }
        }
    }
}

if (!empty($add_index_sql)) {
    try {
        $sql_query_exec = DB::connect()->query($add_index_sql);

        if ($sql_query_exec) {
            $sql_query_exec->closeCursor();
        }
        
        if ($log_query) {
            add_to_error_log($sql_query);
        }
    } catch (PDOException $e) {
        $error_message = $e->getMessage();
        add_to_error_log($error_message);
    }
}

if ($repeat_task) {
    $page_content = [
        'title' => 'Analysing Database Tables',
        'loading_text' => 'Analysing Database Tables',
        'subtitle' => 'Please Wait',
        'redirect' => 'index.php?process=update_database&sub_process=compare_db_tables'
    ];
} else {
    $page_content = [
        'title' => 'Importing Language Strings',
        'loading_text' => 'Importing Language Strings',
        'subtitle' => 'Please Wait',
        'redirect' => 'index.php?process=update_database&sub_process=language_strings'
    ];
}