<?php
function backupDatabase() {
  $db_info = $GLOBALS["database_info"];

  $conn = new mysqli($db_info['host'], $db_info['username'], $db_info['password'], $db_info['database'], $db_info['port']);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Set character encoding to UTF-8
    $conn->set_charset("utf8mb4");

    // Get a list of all tables in the database
    $tables = array();
    $result = $conn->query("SHOW TABLES");

    while ($row = $result->fetch_row()) {
        $tables[] = $row[0];
    }

    // Initialize backup SQL
    $backupSQL = "";

    // Iterate over each table and backup its structure and data
    foreach ($tables as $table) {
        // Backup table structure (including indexes and foreign keys)
        $result = $conn->query("SHOW CREATE TABLE $table");
        $row = $result->fetch_row();
        $createTableSQL = $row[1];

        // Append the index information (except primary key)
        $indexResult = $conn->query("SHOW INDEX FROM $table");

        while ($indexRow = $indexResult->fetch_assoc()) {
            $indexName = $indexRow['Key_name'];
            $columnName = $indexRow['Column_name'];

            if ($indexName !== 'PRIMARY') { // Exclude primary key index
                $createTableSQL .= "ALTER TABLE $table ADD INDEX $indexName ($columnName);\n";
            }
        }

        // Append foreign key constraints
        $fkResult = $conn->query("SHOW CREATE TABLE $table");
        $fkRow = $fkResult->fetch_row();
        $createTableSQL .= "\n" . $fkRow[1] . ";\n";

        $backupSQL .= "\n\n" . $createTableSQL . ";\n\n";

        // Backup table data
        $result = $conn->query("SELECT * FROM $table");

        while ($row = $result->fetch_assoc()) {
            $columnNames = implode(",", array_map('addBackticks', array_keys($row)));
            $columnValues = implode(",", array_map('addQuotes', $row));

            $backupSQL .= "INSERT INTO $table ($columnNames) VALUES ($columnValues);\n";
        }

        $backupSQL .= "\n";
    }

    // Save the backup to a file
    $backupFileName = 'backup/backup_' . date('Y-m-d_H-i-s') . '.sql';
    file_put_contents($backupFileName, $backupSQL);

    // Close the database connection
    $conn->close();
}

// Helper function to add backticks around column names
function addBackticks($columnName) {
    return "`$columnName`";
}

// Helper function to add single quotes around values
function addQuotes($value) {
    return "'" . $value . "'";
}
?>
